<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_financial_adjustment_events', function (Blueprint $table) {
            $table->string('checksum')->after('id');

            // Drop the foreign key constraint
            $table->dropForeign('afaet_amazon_financial_event_group_index');
            // Drop the index
            $table->dropIndex('afaet_amazon_financial_event_group_index');
            //Drop column
            $table->dropColumn('amazon_financial_event_group_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_financial_adjustment_events', function (Blueprint $table) {
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afaet_amazon_financial_event_group_index');
        });
    }
};
