<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_financial_shipment_events', function (Blueprint $table) {
            // Drop the foreign key constraint
            $table->dropForeign('afset_amazon_financial_event_group_index');
            // Drop the index
            $table->dropIndex('afset_amazon_financial_event_group_index');
            // Drop the column
            $table->dropColumn('amazon_financial_event_group_id');
        });

        Schema::table('amazon_financial_refund_events', function (Blueprint $table) {
            // Drop the foreign key constraint
            $table->dropForeign('afrset_amazon_financial_event_group_index');
            // Drop the index
            $table->dropIndex('afrset_amazon_financial_event_group_index');
            // // Drop the column
            $table->dropColumn('amazon_financial_event_group_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_financial_shipment_events', function (Blueprint $table) {
            $table->unsignedBigInteger('amazon_financial_event_group_id')->nullable();
            $table->foreign('amazon_financial_event_group_id', 'afset_amazon_financial_event_group_index')->references('id')->on('amazon_financial_event_groups')->onDelete('cascade');
        });

        Schema::table('amazon_financial_refund_events', function (Blueprint $table) {
            $table->unsignedBigInteger('amazon_financial_event_group_id')->nullable();
            $table->foreign('amazon_financial_event_group_id', 'afret_amazon_financial_event_group_index')->references('id')->on('amazon_financial_event_groups')->onDelete('cascade');
        });
    }
};
