<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('accounting_transactions', function (Blueprint $table) {
            $table->dropUnique('accounting_transactions_link_id_link_type_unique');
            $table->unique(['type', 'link_id', 'link_type'], 'accounting_transactions_link_id_link_type_type_unique');
        });
    }

    public function down(): void
    {
        Schema::table('accounting_transactions', function (Blueprint $table) {
            $table->dropUnique('accounting_transactions_link_id_link_type_type_unique');
            $table->unique(['link_id', 'link_type'], 'accounting_transactions_link_id_link_type_unique');
        });
    }
};
