<?php

use App\Models\NominalCode;
use App\Models\Setting;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {
    public function up(): void
    {
        /** @var NominalCode $nominalCodeInventoryInTransit */
        $nominalCodeInventoryInTransit = NominalCode::query()->firstOrCreate([
            'code' => 102,
            'type' => NominalCode::TYPE_CURRENT,
            'name' => 'Inventory In Transit',
        ]);

        Setting::query()->firstOrCreate([
            'key' => Setting::KEY_NC_MAPPING_INVENTORY_IN_TRANSIT,
            'description' => 'Inventory In Transit',
            'type' => Setting::TYPE_INTEGER,
            'value' => $nominalCodeInventoryInTransit->id,
        ]);
    }
};
