<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_financial_shipment_events', function (Blueprint $table) {
            $table->json('ShipmentItemList')->storedAs('JSON_UNQUOTE(json_extract(json_object, "$.ShipmentItemList"))')->after('PostedDate');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_financial_shipment_events', function (Blueprint $table) {
            $table->dropColumn('ShipmentItemList');
        });
    }
};
