<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        DB::statement("
            UPDATE
                shopify_orders
            SET
                processedAtUtc = CONVERT_TZ(
                    LEFT(processed_at, 19), CONCAT(SUBSTRING(processed_at, 20, 3), ':', SUBSTRING(processed_at, 24, 2)), '+00:00'
                )
            WHERE processedAtUtc IS NULL;
        ");
    }
};
