<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {

    public function up(): void
    {
        Schema::table('store_email_templates', function (Blueprint $table) {
            $table->boolean('system_template')->default(false)->after('enabled');
            $table->json('cc')->nullable()->after('system_template');
        });

        \Illuminate\Support\Facades\DB::table('store_email_templates')->update(['system_template' => true]);
    }

    public function down(): void
    {
        Schema::table('store_email_templates', function (Blueprint $table) {
            $table->dropColumn('system_template', 'cc');
        });
    }
};
