<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('inventory_forecast_items', function (Blueprint $table) {
            $table->decimal('unit_cost', 10, 4)->default(0)->after('suggested_purchase_quantity');
            $table->decimal('unit_cost_in_tenant_currency', 10, 4)->default(0)->after('unit_cost');
            $table->string('tenant_currency_code', 4)->after('tenant_currency_id');

            $table->index('tenant_currency_id');
            $table->index('tenant_currency_code');
            $table->dropColumn(['total_cost', 'conversion_rate', 'forecast_date']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('inventory_forecast_items', function (Blueprint $table) {
            $table->dropColumn(['unit_cost', 'unit_cost_in_tenant_currency', 'tenant_currency_code']);
            $table->decimal('total_cost', 10, 4)->default(0)->after('suggested_purchase_quantity');
            $table->decimal('conversion_rate', 10, 4)->default(0)->after('total_cost');
            $table->date('forecast_date')->nullable()->after('out_of_stock_date');

            $table->dropIndex(['tenant_currency_id', 'tenant_currency_code']);
        });
    }
};
