<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('inventory_forecast_items', function (Blueprint $table) {
            $table->unsignedBigInteger('tenant_currency_id')->nullable()->after('total_cost');
            $table->decimal('conversion_rate', 10, 5)->nullable()->after('tenant_currency_id');

            $table->foreign('tenant_currency_id')->references('id')->on('currencies')
                ->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('inventory_forecast_items', function (Blueprint $table) {
            $table->dropColumn('tenant_currency_id');
            $table->dropColumn('conversion_rate');
        });
    }
};
