<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('forecast_item_po_line_links', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('forecast_item_id');
            $table->unsignedBigInteger('purchase_order_line_id');
            $table->timestamps();

            $table->foreign('forecast_item_id')
                ->references('id')
                ->on('inventory_forecast_items')
                ->cascadeOnDelete();

            $table->foreign('purchase_order_line_id')
                ->references('id')
                ->on('purchase_order_lines')
                ->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('forecast_item_po_line_links');
    }
};
