<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('inventory_forecast_items', function (Blueprint $table) {
            $table->dropForeign('inventory_forecasts_cache_supplier_id_foreign');
            $table->dropForeign('inventory_forecasts_cache_product_id_foreign');
            $table->dropForeign('inventory_forecasts_cache_purchase_order_line_id_foreign');
            $table->dropForeign('inventory_forecasts_cache_warehouse_id_foreign');

            $table->foreign('supplier_id')->references('id')->on('suppliers')->cascadeOnDelete();
            $table->foreign('product_id')->references('id')->on('products')->cascadeOnDelete();
            $table->foreign('purchase_order_line_id')->references('id')->on('purchase_order_lines')->cascadeOnDelete();
            $table->foreign('warehouse_id')->references('id')->on('warehouses')->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('inventory_forecast_items', function (Blueprint $table) {
            $table->dropForeign('inventory_forecast_items_supplier_id_foreign');
            $table->dropForeign('inventory_forecast_items_product_id_foreign');
            $table->dropForeign('inventory_forecast_items_purchase_order_line_id_foreign');
            $table->dropForeign('inventory_forecast_items_warehouse_id_foreign');

            $table->foreign('supplier_id', 'inventory_forecasts_cache_supplier_id_foreign')->references('id')->on('suppliers')->cascadeOnDelete();
            $table->foreign('product_id', 'inventory_forecasts_cache_product_id_foreign')->references('id')->on('products')->cascadeOnDelete();
            $table->foreign('purchase_order_line_id', 'inventory_forecasts_cache_purchase_order_line_id_foreign')->references('id')->on('purchase_order_lines')->cascadeOnDelete();
            $table->foreign('warehouse_id', 'inventory_forecasts_cache_warehouse_id_foreign')->references('id')->on('warehouses')->cascadeOnDelete();
        });
    }
};
