<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('sales_channel_product_template_fields', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sales_channel_product_template_id');
            $table->foreignId('sales_channel_field_definition_id');
            $table->json('default_value')->nullable();
            $table->string('type');
            $table->timestamps();
            $table->unique(['sales_channel_product_template_id', 'sales_channel_field_definition_id'], 'unique_template_field');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sales_channel_product_template_fields');
    }
};
