<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('sales_channel_product_templates', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('sales_channel_id')->index();
            $table->string('name');
            $table->timestamps();
            $table->foreign('sales_channel_id')->references('id')->on('sales_channels')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sales_channel_product_templates');
    }
};
