<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('inventory_forecast_summary', function (Blueprint $table) {
            $table->integer('days_of_sales_history')->after('id')->nullable();
            $table->integer('max_projection_days')->after('days_of_sales_history')->nullable();
            $table->dropColumn(['total', 'processed']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('inventory_forecast_summary', function (Blueprint $table) {
            $table->dropColumn(['days_of_sales_history', 'max_projection_days']);
            $table->integer('total')->after('id');
            $table->integer('processed')->after('total');
        });
    }
};
