<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        DB::statement('DELETE FROM sales_order_line_financials WHERE sales_order_line_id NOT IN (SELECT id FROM sales_order_lines)');
        Schema::table('sales_order_line_financials', function (Blueprint $table) {
            $table->foreign('sales_order_line_id')->references('id')->on('sales_order_lines')->cascadeOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('sales_order_line_financials', function (Blueprint $table) {
            $table->dropForeign(['sales_order_line_id']);
        });
    }
};
