<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fulfillment_order_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_fulfillment_order_id')->index('fulfillmentOrderIndex');
            $table->string('sellerSku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sellerSku'))");
            $table->string('sellerFulfillmentOrderItemId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sellerFulfillmentOrderItemId'))");
            $table->integer('quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.quantity'))");
            $table->string('giftMessage')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.giftMessage'))");
            $table->string('displayableComment')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.displayableComment'))");
            $table->string('fulfillmentNetworkSku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fulfillmentNetworkSku'))");
            $table->string('orderItemDisposition')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.orderItemDisposition'))");
            $table->integer('cancelledQuantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.cancelledQuantity'))");
            $table->integer('unfulfillableQuantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.unfulfillableQuantity'))");
            $table->string('estimatedShipDate')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.estimatedShipDate'))");
            $table->string('estimatedArrivalDate')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.estimatedArrivalDate'))");
            $table->string('perUnitPriceCurrencyCode')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.perUnitPrice.currencyCode'))");
            $table->decimal('perUnitPriceCurrencyValue', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.perUnitPrice.value'))");
            $table->string('perUnitTaxCurrencyCode')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.perUnitTax.currencyCode'))");
            $table->decimal('perUnitTaxValue', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.perUnitTax.value'))");
            $table->string('perUnitDeclaredValueCurrencyCode')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.perUnitDeclaredValue.currencyCode'))");
            $table->decimal('perUnitDeclaredValueValue', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.perUnitDeclaredValue.value'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fulfillment_order_items');
    }
};
