<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fulfillment_orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index('integrationInstanceIndex');
            $table->foreignId('sales_order_fulfillment_id')->nullable()->index('salesOrderFulfillmentIndex');
            $table->string('sellerFulfillmentOrderId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sellerFulfillmentOrderId'))");
            $table->string('marketplaceId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.marketplaceId'))");
            $table->string('displayableOrderId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.displayableOrderId'))");
            $table->string('displayableOrderDate')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.displayableOrderDate'))");
            $table->string('displayableOrderComment')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.displayableOrderComment'))");
            $table->string('shippingSpeedCategory')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shippingSpeedCategory'))");
            $table->string('deliveryWindow')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.deliveryWindow'))");
            $table->json('destinationAddress')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.destinationAddress'))");
            $table->string('fulfillmentAction')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fulfillmentAction'))");
            $table->string('fulfillmentPolicy')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fulfillmentPolicy'))");
            $table->json('codSettings')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.codSettings'))");
            $table->string('receivedDate')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.receivedDate'))");
            $table->string('fulfillmentOrderStatus')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fulfillmentOrderStatus'))");
            $table->string('statusUpdatedDate')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.statusUpdatedDate'))");
            $table->json('notificationEmails')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.notificationEmails'))");
            $table->json('featureConstraints')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.featureConstraints'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fulfillment_orders');
    }
};
