<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('qbo_invoices', function (Blueprint $table) {
            $table->dateTime('LastUpdatedTimeUtc')->storedAs("str_to_date(REPLACE(json_unquote(json_extract(`json_object`,'$.LastUpdatedTimeUtc')), 'T', ' '), '%Y-%m-%d %H:%i:%s')")->nullable()->before('json_object');

        });

        Schema::table('qbo_bills', function (Blueprint $table) {
            $table->dateTime('LastUpdatedTimeUtc')->storedAs("str_to_date(REPLACE(json_unquote(json_extract(`json_object`,'$.LastUpdatedTimeUtc')), 'T', ' '), '%Y-%m-%d %H:%i:%s')")->nullable()->before('json_object');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('qbo_invoices', function (Blueprint $table) {
            $table->dropColumn('LastUpdatedTimeUtc');
        });

        Schema::table('qbo_bills', function (Blueprint $table) {
            $table->dropColumn('LastUpdatedTimeUtc');
        });
    }
};
