<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('warehouse_transfer_shipment_receipts', function (Blueprint $table) {
            $table->foreignId('user_id')->nullable()->after('warehouse_transfer_shipment_id')->constrained();
        });
    }

    public function down(): void
    {
        Schema::table('warehouse_transfer_shipment_receipts', function (Blueprint $table) {
            $table->dropConstrainedForeignId('user_id');
        });
    }
};
