<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('integration_instances', function (Blueprint $table) {
            $table->string('country')->nullable()->after('connection_status');
        });

        DB::statement('UPDATE integration_instances ii INNER JOIN integrations i ON i.id = ii.integration_id SET ii.country = i.country');
    }

    public function down(): void
    {
        Schema::table('integration_instances', function (Blueprint $table) {
            $table->dropColumn('country');
        });
    }
};
