<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('qbo_invoices', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained();
            $table->string('QboId')->unique()->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Id'))");
            $table->string('DocNumber')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.DocNumber'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('qbo_invoices');
    }
};
