<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_feed_requests', function (Blueprint $table) {
            $table->text('requestFeedDocumentXml')->nullable()->after('metadata');
        });

        Schema::table('amazon_feed_submissions', function (Blueprint $table) {
            $table->text('requestFeedDocumentXml')->nullable()->after('metadata');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_feed_requests', function (Blueprint $table) {
            $table->dropColumn('requestFeedDocumentXml');
        });

        Schema::table('amazon_feed_submissions', function (Blueprint $table) {
            $table->dropColumn('requestFeedDocumentXml');
        });
    }
};
