<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        Schema::table('veracore_orders', function (Blueprint $table) {

            // Remove "on delete cascade" constraint to allow for nullable field
            $constraint = 'veracore_orders_sku_fulfillment_id_foreign';
            \Illuminate\Support\Facades\DB::unprepared("ALTER TABLE veracore_orders DROP FOREIGN KEY $constraint;");

            $table->unsignedBigInteger('sku_fulfillment_id')->nullable()->change();
            // Add foreign key constraint back
            $table->foreign('sku_fulfillment_id')
                ->references('id')
                ->on('sales_order_fulfillments')
                ->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('veracore_orders', function (Blueprint $table) {

            $constraint = 'veracore_orders_sku_fulfillment_id_foreign';
            \Illuminate\Support\Facades\DB::unprepared("ALTER TABLE veracore_orders DROP FOREIGN KEY $constraint;");

            $table->unsignedBigInteger('sku_fulfillment_id')->nullable(false)->change();
            $table->foreign('sku_fulfillment_id')
                ->references('id')
                ->on('sales_order_fulfillments')
                ->cascadeOnDelete();
        });
    }

};
