<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // Delete duplicate product images
        DB::statement('DELETE pi1 FROM product_images pi1
JOIN product_images pi2 
ON pi1.product_id = pi2.product_id 
AND pi1.url = pi2.url 
AND pi1.id > pi2.id');

        Schema::table('product_images', function (Blueprint $table) {
            $table->string('url', 500)->change();
        });

        Schema::table('product_images', function (Blueprint $table) {
            $table->unique(['product_id', 'url'], 'product_images_unique_idx');
        });
    }

    public function down(): void
    {
        Schema::table('product_images', function (Blueprint $table) {
            $table->dropUnique('product_images_unique_idx');
        });

        Schema::table('product_images', function (Blueprint $table) {
            $table->text('url')->change();
        });
    }
};
