<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Artisan::call('patch:fix-duplicate-warehouses');

        Schema::table('warehouses', function (Blueprint $table) {
            $table->unique('name', 'warehouses_unique_idx');
        });
    }

    public function down(): void
    {
        Schema::table('warehouses', function (Blueprint $table) {
            $table->dropUnique('warehouses_unique_idx');
        });
    }
};
