<?php

use App\DTO\PaymentTypeData;
use App\Models\PaymentType;
use App\Repositories\PaymentTypeRepository;
use Illuminate\Database\Migrations\Migration;
use Modules\Amazon\Entities\AmazonIntegrationInstance;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (AmazonIntegrationInstance::query()->count() > 0) {
            (new PaymentTypeRepository())->save(PaymentTypeData::from([
                'name' => PaymentType::PAYMENT_TYPE_AMAZON,
            ]));
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
