<?php

use App\Helpers;
use App\Models\Setting;
use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('supplier_inventory', function (Blueprint $table) {
            $table->dateTime('eta')->change();
        });

        $timezone = Helpers::setting(Setting::KEY_DEFAULT_TIMEZONE, config('app.timezone'));
        DB::table('supplier_inventory')->cursor()->each(function ($supplierInventory) use ($timezone) {
            $eta = $supplierInventory->eta ?
                Carbon::parse($supplierInventory->eta, $timezone)
                    ->timezone(config('app.timezone')) :
                null;
            DB::table('supplier_inventory')->where('id', $supplierInventory->id)->update([
                'eta' => $eta,
            ]);

        });
    }
};
