<?php

use App\Helpers;
use App\Models\Setting;
use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        ini_set('memory_limit', '8G');
        Schema::table('purchase_order_lines', function (Blueprint $table) {
            $table->dateTime('estimated_delivery_date')->change();
        });

        $timezone = Helpers::setting(Setting::KEY_DEFAULT_TIMEZONE, config('app.timezone'));
        DB::table('purchase_order_lines')->cursor()->each(function ($purchaseOrderLine) use ($timezone) {
            $estimated_delivery_date = $purchaseOrderLine->estimated_delivery_date ?
                Carbon::parse($purchaseOrderLine->estimated_delivery_date, $timezone)
                    ->timezone(config('app.timezone')) :
                null;
            DB::table('purchase_order_lines')->where('id', $purchaseOrderLine->id)->update([
                'estimated_delivery_date' => $estimated_delivery_date,
            ]);

        });
    }
};
