<?php

use App\Helpers;
use App\Models\Setting;
use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('inventory_forecast_summary', function (Blueprint $table) {
            $table->dateTime('forecast_date')->change();
        });

        $timezone = Helpers::setting(Setting::KEY_DEFAULT_TIMEZONE, config('app.timezone'));
        DB::table('inventory_forecast_summary')->cursor()->each(function ($inventoryForecastSummary) use ($timezone) {
            $forecast_date = $inventoryForecastSummary->forecast_date ?
                Carbon::parse($inventoryForecastSummary->forecast_date, $timezone)
                    ->timezone(config('app.timezone')) :
                null;
            DB::table('inventory_forecast_summary')->where('id', $inventoryForecastSummary->id)->update([
                'forecast_date' => $forecast_date,
            ]);

        });
    }
};
