<?php

use App\Helpers;
use App\Models\Setting;
use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('generated_reports', function (Blueprint $table) {
            $table->dateTime('start_date')->change();
            $table->dateTime('end_date')->change();
        });

        $timezone = Helpers::setting(Setting::KEY_DEFAULT_TIMEZONE, config('app.timezone'));
        DB::table('generated_reports')->cursor()->each(function ($generatedReport) use ($timezone) {
            $start_date = $generatedReport->start_date ?
                Carbon::parse($generatedReport->start_date, $timezone)
                    ->timezone(config('app.timezone')) :
                null;
            $end_date = $generatedReport->end_date ?
                Carbon::parse($generatedReport->end_date, $timezone)
                    ->timezone(config('app.timezone')) :
                null;
            DB::table('generated_reports')->where('id', $generatedReport->id)->update([
                'start_date' => $start_date,
                'end_date' => $end_date,
            ]);

        });
    }
};
