<?php

use App\Helpers;
use App\Models\Setting;
use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('generated_report_items', function (Blueprint $table) {
            $table->dateTime('date')->change();
        });

        $timezone = Helpers::setting(Setting::KEY_DEFAULT_TIMEZONE, config('app.timezone'));
        DB::table('generated_report_items')->cursor()->each(function ($generatedReportItem) use ($timezone) {
            $date = $generatedReportItem->date ?
                Carbon::parse($generatedReportItem->date, $timezone)
                    ->timezone(config('app.timezone')) :
                null;
            DB::table('generated_report_items')->where('id', $generatedReportItem->id)->update([
                'date' => $date,
            ]);

        });
    }
};
