<?php

use App\Helpers;
use App\Models\Setting;
use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        ini_set('memory_limit', '8G');
        Schema::table('fifo_layers', function (Blueprint $table) {
            $table->dateTime('fifo_layer_date')->change();
        });

        $timezone = Helpers::setting(Setting::KEY_DEFAULT_TIMEZONE, config('app.timezone'));
        DB::table('fifo_layers')->cursor()->each(function ($fifoLayer) use ($timezone) {
            $fifo_layer_date = $fifoLayer->fifo_layer_date ?
                Carbon::parse($fifoLayer->fifo_layer_date, $timezone)
                    ->timezone(config('app.timezone')) :
                null;
            DB::table('fifo_layers')->where('id', $fifoLayer->id)->update([
                'fifo_layer_date' => $fifo_layer_date,
            ]);

        });
    }
};
