<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('sales_order_fulfillments', function (Blueprint $table) {
            $table->string('sales_channel_link_type')->nullable()->after('metadata');
            $table->integer('sales_channel_link_id')->nullable()->after('sales_channel_link_type');
            $table->index(['sales_channel_link_type', 'sales_channel_link_id'], 'sales_channel_link_type_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('sales_order_fulfillments', function (Blueprint $table) {
            $table->dropColumn('sales_channel_link_type');
            $table->dropColumn('sales_channel_link_id');
            $table->dropIndex('sales_channel_link_type_id');
        });
    }
};
