<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('veracore_orders', function (Blueprint $table) {
            $table->id();
            $table->json('json_data');
            $table->unsignedBigInteger('sku_fulfillment_id')->unique();
            $table->unsignedBigInteger('veracore_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(`json_data`, '$.Order.OrderID'))");
            $table->string('ReferenceNumber')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(`json_data`, '$.Order.ReferenceNumber'))");
            $table->string('CurrentOrderStatus')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(`json_data`, '$.Order.CurrentOrderStatus'))");
            $table->timestamps();
            $table->foreign('sku_fulfillment_id')->references('id')->on('sales_order_fulfillments')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('veracore_orders');
    }
};
