<?php

namespace Database\Factories;

use App\Models\Product;
use App\Models\WarehouseTransfer;
use App\Models\SupplierProduct;
use App\Models\WarehouseTransferLine;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\WarehouseTransferLine>
 */
class WarehouseTransferLineFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'warehouse_transfer_id' => WarehouseTransfer::factory(),
            'product_id' => Product::factory(),
            'quantity' => $this->faker->numberBetween(1, 10),
            'description' => $this->faker->sentence(),
        ];
    }

    public function withSupplierProduct(): self
    {
        return $this->afterCreating(function (WarehouseTransferLine $line) {
            SupplierProduct::factory()->create(['product_id' => $line->product_id]);
        });
    }
}
