<?php

namespace Database\Factories;

use App\Models\Product;
use App\Models\Warehouse;
use App\Models\WarehouseLocation;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;

class WarehouseTransferFactory extends Factory
{
    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'warehouse_transfer_number' => $this->faker->unique()->word(),
            'transfer_date' => Carbon::now()->format('Y-m-d H:i:s'),
            'from_warehouse_id' => Warehouse::factory()->hasDefaultLocation(),
            'to_warehouse_id' => Warehouse::factory()->hasDefaultLocation(),
            'shipping_method_id' => \App\Models\ShippingMethod::factory()->create()->id,
        ];
    }
}
