<?php

namespace Database\Factories;

use App\Models\UserAlertSetting;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;

class UserAlertFactory extends Factory
{
    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'priority' => $this->faker->numberBetween(0, 9),
            'alert_type' => $this->faker->randomElement(UserAlertSetting::ALERT_TYPES),
            'show_in_ui_notification' => $this->faker->boolean(),
            'alert_by_email' => $this->faker->boolean(),
        ];
    }

    public function read()
    {
        return $this->state(['read_at' => Carbon::now()]);
    }

    public function unread()
    {
        return $this->state(['read_at' => null]);
    }

    public function showInUi()
    {
        return $this->state(['show_in_ui_notification' => 1]);
    }
}
