<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;

use App\Enums\TrackedJobLogStatusEnum;

class TrackedJobLogFactory extends Factory
{
    public function definition(): array
    {
        $relatedModel = $this->faker->randomElement([
            \App\Models\User::class,
            \App\Models\Product::class,
            \App\Models\PurchaseOrder::class,
        ]);

        $relatedModelInstance = $relatedModel::factory()->create();

        return [
            'job_type' => $this->faker->randomElement([
                'App\Jobs\ExampleJob',
                'App\Jobs\AnotherExampleJob',
            ]),
            'queue' => 'default',
            'job_name' => $this->faker->name(),
            'status' => $this->faker->randomElement(TrackedJobLogStatusEnum::cases())->value,
            'related_model_type' => $relatedModel,
            'related_model_id' => $relatedModelInstance->id,
            'job_data' => json_encode(['example_key' => $this->faker->word()]),
            'attempted_at' => Carbon::now(),
            'completed_at' => Carbon::now(),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ];
    }
}
