<?php

namespace Database\Factories;

use App\Models\Product;
use App\Models\Supplier;
use App\Models\SupplierPricingTier;
use App\Models\SupplierProduct;
use App\Models\SupplierProductPricing;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\SupplierProductPricing>
 */
class SupplierProductPricingFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'price' => $this->faker->numberBetween(2, 50),
        ];
    }

    public function setPricing(SupplierPricingTier $supplierPricingTier, Supplier $supplier, Product $product, float $amount): void
    {
        // Bypass default configure for SupplierProductFactory
        $supplierProduct = SupplierProduct::create([
            'supplier_id' => $supplier->id,
            'product_id' => $product->id,
        ]);

        SupplierProductPricing::factory()->create([
            'supplier_product_id' => $supplierProduct->id,
            'supplier_pricing_tier_id' => $supplierPricingTier->id,
            'price' => $amount,
        ]);
    }
}
