<?php

namespace Database\Factories;

use App\Models\StoreEmailTemplate;
use Illuminate\Database\Eloquent\Factories\Factory;

class StoreEmailTemplateFactory extends Factory
{
    protected $model = StoreEmailTemplate::class;

    public function definition(): array
    {
        $types = [
            StoreEmailTemplate::TYPE_CONTEXT_SALES_ORDER
        ];
        return [
            'type' => $types[rand(0, count($types) - 1)],
            'subject' => $this->faker->word(),
            'html_body' => $this->faker->word(),
            'enabled' => $this->faker->boolean(),
            'attach_pdf' => $this->faker->boolean(),
            'sent_type' => StoreEmailTemplate::SENT_TYPE_MANUALLY,
            'is_system_template' => $this->faker->boolean(),
            'cc' => [$this->faker->unique()->email],
            'store_id' => 1,
        ];
    }
}
