<?php

namespace Database\Factories;

use App\Models\StockTake;
use App\Models\Warehouse;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\StockTake>
 */
class StockTakeFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'date_count' => $this->faker->date(),
            'warehouse_id' => Warehouse::factory(),
        ];
    }

    public function finalized()
    {
        return $this->state(function () {
            return [
                'status' => StockTake::STOCK_TAKE_STATUS_CLOSED,
            ];
        });
    }
}
