<?php

namespace Database\Factories\Shopify;

use App\Models\IntegrationInstance;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Shopify\ShopifyProduct>
 */
class ShopifyProductFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $variant_id = $this->faker->unique()->numberBetween(1000, 2000);

        return [
            'variant_id' => $variant_id,
            'json_object' => [
                'sku' => $this->faker->unique()->word,
                'variant_id' => $variant_id,
                'name' => $this->faker->sentence,
            ],
        ];
    }
}
