<?php

namespace Database\Factories;

use App\Models\SalesOrderLine;
use App\Models\SalesOrderLineFinancial;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @mixin SalesOrderLineFinancial
 */
class SalesOrderLineFinancialFactory extends Factory
{
    public function definition(): array
    {
        return [
            'sales_order_line_id' => SalesOrderLine::factory(),
            'revenue' => $this->faker->randomFloat(2, 0, 1000),
            'revenue_allocated' => $this->faker->randomFloat(2, 0, 1000),
            'credits' => $this->faker->randomFloat(2, 0, 1000),
            'cogs' => $this->faker->randomFloat(2, 0, 1000),
            'cogs_returned' => $this->faker->randomFloat(2, 0, 1000),
            'cost_allocated' => $this->faker->randomFloat(2, 0, 1000),
        ];
    }
}
