<?php

namespace Database\Factories;

use App\Models\SalesOrder;
use App\Models\Warehouse;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\SalesOrderFulfillment>
 */
class SalesOrderFulfillmentFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'fulfilled_at' => $this->faker->date(),
            'warehouse_id' => Warehouse::factory(),
            'sales_order_id' => SalesOrder::factory(),
        ];
    }
}
