<?php

namespace Database\Factories;

use App\Models\ReturnReason;
use App\Models\SalesCreditLine;
use App\Models\SalesCreditReturn;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\SalesCreditReturnLine>
 */
class SalesCreditReturnLineFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'reason_id' => ReturnReason::factory(),
            'sales_credit_line_id' => SalesCreditLine::factory(),
            'sales_credit_return_id' => SalesCreditReturn::factory(),
            'quantity' => $this->faker->numberBetween(1, 5),
        ];
    }
}
