<?php

namespace Database\Factories;

use App\Models\InventoryMovement;
use App\Models\SalesCredit;
use App\Models\SalesCreditReturn;
use App\Models\SalesCreditReturnLine;
use App\Models\Warehouse;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\Sequence;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\SalesCreditReturn>
 */
class SalesCreditReturnFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'status' => $this->faker->randomElement(SalesCreditReturn::STATUSES),
            'sales_credit_id' => SalesCredit::factory(),
            'warehouse_id' => Warehouse::factory(),
            'received_at' => $this->faker->dateTimeThisYear(),
        ];
    }

    public function returned(SalesCredit $salesCredit, int $numLines, ?string $dateOfReturn = null)
    {
        return $this
            ->has(
                SalesCreditReturnLine::factory($numLines)
                    ->state(new Sequence(
                        fn ($sequence) => [
                            'sales_credit_line_id' => ($line = $salesCredit->salesCreditLines()->offset($sequence->index)->first())->id,
                            'quantity' => $line->quantity,
                        ]
                    ))
                    ->has(
                        InventoryMovement::factory($numLines)
                            ->state(function (array $attributes, SalesCreditReturnLine $salesCreditReturnLine) {
                                return [
                                    'link_id' => $salesCreditReturnLine->id,
                                    'link_type' => SalesCreditReturnLine::class,
                                    'type' => InventoryMovement::TYPE_RETURN,
                                    'quantity' => $salesCreditReturnLine->quantity,
                                ];
                            }))
            )->create([
                'sales_credit_id' => $salesCredit->id,
                'received_at' => $dateOfReturn,
                'status' => 'closed'
            ]);
    }
}
