<?php

namespace Database\Factories;

use App\Models\SalesChannel;
use App\Models\SalesChannelProductTemplate;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;

class SalesChannelProductTemplateFactory extends Factory
{
    protected $model = SalesChannelProductTemplate::class;

    public function definition(): array
    {
        return [
            'sales_channel_id' => SalesChannel::factory(),
            'name' => $this->faker->name(),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ];
    }
}
