<?php

namespace Database\Factories;

use App\Models\Product;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;

class ReportingDailyFinancialFactory extends Factory
{
    public function definition(): array
    {
        return [
            'date' => Carbon::now(),
            'quantity' => $this->faker->randomNumber(),
            'num_orders' => $this->faker->randomNumber(),
            'revenue' => $this->faker->randomFloat(null, 0, 100_000),
            'revenue_allocated' => $this->faker->randomFloat(null, 0, 100_000),
            'revenue_credits' => $this->faker->randomFloat(null, 0, 100_000),
            'cost' => $this->faker->randomFloat(null, 0, 100_000),
            'cost_allocated' => $this->faker->randomFloat(null, 0, 100_000),
            'cost_invoices' => $this->faker->randomFloat(null, 0, 100_000),
            'cost_returned' => $this->faker->randomFloat(null, 0, 100_000),
        ];
    }
}
