<?php

namespace Database\Factories;

use App\Models\InventoryMovement;
use App\Models\PurchaseOrderLine;
use App\Models\PurchaseOrderShipmentLine;
use App\Models\PurchaseOrderShipmentReceiptLine;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\PurchaseOrderShipmentReceiptLine>
 */
class PurchaseOrderShipmentReceiptLineFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        /*
         * Note PurchaseOrderShipmentReceiptLine will not work without the purchase_order_shipment_line_id
         * so this factory can only be used by utilizing the state override to set the
         * purchase_order_shipment_line_id to be the appropriate sibling id
         */
        return [
            'purchase_order_shipment_line_id' => PurchaseOrderShipmentLine::factory(),
            'purchase_order_line_id' => PurchaseOrderLine::factory(),
            'quantity' => $this->faker->numberBetween(1, 10),
        ];
    }

    public function withInventoryMovement()
    {
        return
            $this->has(
                InventoryMovement::factory()
                    ->state(function ($attributes, PurchaseOrderShipmentReceiptLine $purchaseOrderShipmentReceiptLine) {
                        return [
                            'inventory_movement_date' => $purchaseOrderShipmentReceiptLine->purchaseOrderShipmentReceipt->received_at,
                            'link_type' => PurchaseOrderShipmentReceiptLine::class,
                            'link_id' => $purchaseOrderShipmentReceiptLine->id,
                            'quantity' => $purchaseOrderShipmentReceiptLine->quantity,
                            'type' => InventoryMovement::TYPE_PURCHASE_RECEIPT,
                            'inventory_status' => InventoryMovement::INVENTORY_STATUS_ACTIVE,
                            'product_id' => $purchaseOrderShipmentReceiptLine->purchaseOrderShipmentLine->purchaseOrderLine->product->id,
                        ];
                    })/*->hasLayer(null, function (array $attributes, InventoryMovement $inventoryMovement) {
                        return [
                            'product_id' => $inventoryMovement->product->id,
                            'link_id' => $inventoryMovement->link_id,
                            'link_type' => $inventoryMovement->link_type,
                        ];
                    })*/
            );
    }
}
