<?php

namespace Database\Factories;

use App\Models\PurchaseOrderShipment;
use App\Models\PurchaseOrderShipmentLine;
use App\Models\PurchaseOrderShipmentReceiptLine;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\Sequence;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\PurchaseOrderShipmentReceipt>
 */
class PurchaseOrderShipmentReceiptFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'purchase_order_shipment_id' => PurchaseOrderShipment::factory(),
            'received_at' => Carbon::now()->format('Y-m-d H:i:s'),
        ];
    }

    public function received(int $numLines)
    {
        return
            $this
                ->has(
                    PurchaseOrderShipmentReceiptLine::factory($numLines)
                        ->state(new Sequence(
                            fn ($sequence) => [
                                'purchase_order_shipment_line_id' => ($line = PurchaseOrderShipmentLine::offset($sequence->index)->first())->id,
                                'purchase_order_line_id' => $line->purchase_order_line_id,
                                'quantity' => $line->quantity,
                            ]
                        )
                        )
                        ->withInventoryMovement()
                );
    }
}
